/*****************************************************************
File:         BML36L532.ino
Description:  
connection method: 
******************************************************************/
#include "BMD31M090.h"
#include "Bitmap.h"
#include "BM32S3031-1.h"
BM32S3031_1   BMS31(&Serial1);                               
BMD31M090     BMD31(128, 64, &Wire2);
uint8_t irStatus = 0;
uint16_t Time = 501;
void setup()
{
  BMD31.begin();
  BMS31.begin();  
  displayInitial();
  delay(2000);
  BMD31.clearDisplay();
  BMD31.display();
}

void loop()
{
  delay(1);
  if(Time < 500)
  {
   Time++;
   if(Time == 500)
   {
    BMD31.clearDisplay();
    BMD31.display();
   }
  }
  if(BMS31.isInfoAvailable()== true)
   {
    irStatus = 0;
    irStatus = BMS31.readInfoPackage(); 
    if(irStatus&0x02)
    {  
     displaysLideRight();
     Time = 0;
    }
   if(irStatus&0x04)
    {  
     displaysLideLeft();
     Time = 0;
    }
    if(irStatus&0x08)
    {  
     displayHover();
     Time = 0;
    }
   }
}


void displayInitial(void)
{
  BMD31.clearDisplay();
  BMD31.display();
  BMD31.setFont(FontTable_8X16);
  BMD31.drawString(25,3,(u8*)"BMS31K303"); 
}


void displaysLideLeft(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 24, slideLeft, 40, 17,1);
  BMD31.display();
}

void displaysLideRight(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 24, slideRight, 40, 17,1);
  BMD31.display();
}

void displayHover(void)
{
  BMD31.clearDisplay();
  BMD31.drawBitmap(44, 12, round_medium, 40, 40,1);
  BMD31.display();
}
