/*****************************************************************
File:             BM32S3031-1.h
Author:           BESTMODULES
Description:      Define classes and required variables
Version:          V1.0.1   -- 2023-12-28
******************************************************************/
#ifndef _BM32S3031_1_H_
#define _BM32S3031_1_H_

#include "Arduino.h"
#include <SoftwareSerial.h>

#define PASSIVE  0x00
#define AUTO     0x01

#define CHECK_OK       0x00
#define CHECK_ERROR    0x01
#define TIMEOUT_ERROR  0x02


class BM32S3031_1
{
  public:
    BM32S3031_1(HardwareSerial *theSerial  = &Serial);
    BM32S3031_1(uint8_t rxPin,uint8_t txPin);
    void begin();
    
    uint8_t getIRStatus(); //获取手势感应状态
    bool isInfoAvailable();//查询是否接收到模块自动输出的信息
    uint8_t readInfoPackage(); //读取模块自动输出手势感应状态
    uint8_t distanceLearning(); //距离学习
    int8_t getIRGestureNum(); //获取左右滑次数
    uint16_t getFWVer(); //获取版本号
    uint8_t reset();  //模块复位
    uint8_t saveSettings();  //将当前参数写入到EEPROM
    uint8_t restoreSettings(); //将EEPROM的参数读取出来，作为当前参数
   
    uint8_t getMode();//获取工作模式
    uint8_t getIRDebounce(); //获取接近感应去抖次数
    uint8_t getGestureThreshold();//获取手势触发阈值
    uint8_t getIRThreshold(); //获取接近感应触发阈值
    uint8_t getIRContinutyGestureTime(); //获取累计连续滑动时长
    uint8_t getIRFastestGestureTime(); //获取最快手势判断时长
    uint8_t getIRSlowestGestureTime(); //获取最慢手势判断时长
    uint8_t getIRTriggerTime();        //获取接近感应触发时长
    uint8_t getGestureStatusHoldTime();//获取手势状态保持时长
    
    uint8_t setMode(uint8_t mode = AUTO);//设置工作模式
    uint8_t setIRDebounce(uint8_t  debounce = 7);  //设置接近感应去抖次数
    uint8_t setGestureThreshold(uint8_t  threshold = 10); //设置手势触发阈值
    uint8_t setIRThreshold(uint8_t  threshold = 25); //设置接近感应触发阈值
    uint8_t setIRContinutyGestureTime(uint8_t  irTime = 32);//设置累计连续滑动时长
    uint8_t setIRFastestGestureTime(uint8_t  irTime = 0);  //设置最快手势判断时长
    uint8_t setIRSlowestGestureTime(uint8_t  irTime = 80); //设置最慢手势判断时长
    uint8_t setIRTriggerTime(uint8_t  irTime = 8); //设置接近感应触发时长
    uint8_t setGestureStatusHoldTime(uint8_t  irTime = 32);//设置手势状态保持时长
    
  private:
    uint8_t readIR1Ref(); //读取IR1 感应值
    uint8_t readIR2Ref(); //读取IR2 感应值
    uint8_t readIrA2_A5(uint8_t  buff[]);//一次性读取感应状态、左右滑次数、IR1/IR2 参考值
    uint8_t getIR1Current(); //获取IR1发射电流
    uint8_t getIR2Current(); //获取IR2发射电流
    uint8_t setIR1Current(uint8_t  current); //设置IR1发射电流
    uint8_t setIR2Current(uint8_t  current); //设置IR2发射电流
    uint8_t checksum(uint8_t len,uint8_t data[]); 
    void writeBytes(uint8_t wbuf[], uint8_t wlen);
    uint8_t readBytes(uint8_t rbuf[], uint8_t rlen, uint16_t timeOut = 200);
    uint8_t _rxPin;
    uint8_t _txPin;
    uint8_t _recBuf[6]={0};
    HardwareSerial *_hardSerial = NULL;
    SoftwareSerial *_softSerial = NULL ;   
};

#endif
